<?php
session_start();
include_once '../includes/db_connect.php';

// 🔐 로그인 확인
if (!isset($_SESSION['user_id'])) {
    die("로그인이 필요합니다.");
}

$userId = $_SESSION['user_id'];

// 🍽️ 로그인한 사용자의 restaurant_id 및 이름 조회
$sql = "SELECT restaurant_id, name FROM Restaurants WHERE user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $userId);
$stmt->execute();
$stmt->bind_result($restaurantId, $restaurantName);
if (!$stmt->fetch()) {
    die("등록된 식당이 없습니다.");
}
$stmt->close();

// 📅 오늘 날짜
$today = date('Y-m-d');

// 📌 오늘 예약 수 조회
$sqlReservations = "SELECT COUNT(*) FROM Reservations 
    WHERE DATE(reservation_time) = ? 
    AND food_id IN (
        SELECT food_id FROM OrderItems 
        JOIN Orders ON OrderItems.order_id = Orders.order_id 
        WHERE Orders.restaurant_id = ?
    )";
$stmt = $conn->prepare($sqlReservations);
$stmt->bind_param("si", $today, $restaurantId);
$stmt->execute();
$stmt->bind_result($todayReservations);
$stmt->fetch();
$stmt->close();

// 📝 오늘 신규 리뷰 수
$sqlReviews = "SELECT COUNT(*) FROM Reviews 
    WHERE DATE(created_at) = ? AND restaurant_id = ?";
$stmt = $conn->prepare($sqlReviews);
$stmt->bind_param("si", $today, $restaurantId);
$stmt->execute();
$stmt->bind_result($newReviews);
$stmt->fetch();
$stmt->close();

// 💰 오늘 매출
$sqlSales = "SELECT total_sales FROM SalesSummary 
    WHERE restaurant_id = ? AND date = ?";
$stmt = $conn->prepare($sqlSales);
$stmt->bind_param("is", $restaurantId, $today);
$stmt->execute();
$stmt->bind_result($todaySales);
$stmt->fetch();
$stmt->close();
$todaySales = $todaySales ?? 0;

// 🛒 실시간 주문 수 (orderd, completed)
$sqlOrderd = "SELECT COUNT(*) FROM Orders 
    WHERE restaurant_id = ? AND DATE(order_time) = ? AND status = 'orderd'";
$stmt = $conn->prepare($sqlOrderd);
$stmt->bind_param("is", $restaurantId, $today);
$stmt->execute();
$stmt->bind_result($orderdCount);
$stmt->fetch();
$stmt->close();

$sqlCompleted = "SELECT COUNT(*) FROM Orders 
    WHERE restaurant_id = ? AND DATE(order_time) = ? AND status = 'completed'";
$stmt = $conn->prepare($sqlCompleted);
$stmt->bind_param("is", $restaurantId, $today);
$stmt->execute();
$stmt->bind_result($completedCount);
$stmt->fetch();
$stmt->close();
?>

<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <title>관리자 홈</title>
    <link rel="stylesheet" href="/css/admin_dashboard.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <style>
        html, body {
            height: 100%;
            margin: 0;
            font-family: "Apple SD Gothic Neo", sans-serif;
            background-color: #f9f9f9;
        }

        .container {
            display: flex;
            flex-direction: column;
            height: 100vh;
            max-width: 400px;
            margin: 0 auto;
            background-color: white;
        }

        .header {
            background-color: #007bff;
            color: white;
            padding: 15px;
            font-size: 1em;
            font-weight: bold;
            text-align: center;
        }

        .dashboard {
        flex: 1;
        padding: 15px;
        overflow-y: auto;
        overflow-x: hidden;
        }

        .card-grid {
        display: block; /* 세로배치용 */
        margin: 0;
        padding: 0;
        }

        .card {
        width: 100%;
        box-sizing: border-box;
        background-color: #fff;
        border-radius: 10px;
        padding: 15px;
        box-shadow: 0 2px 6px rgba(0,0,0,0.05);
        text-align: center;
        margin-bottom: 10px;
        }



        .card-title {
            font-size: 0.9em;
            color: #666;
            margin-bottom: 5px;
        }

        .card-value {
            font-size: 1.2em;
            font-weight: bold;
            color: #333;
        }

        .bottom-nav {
            display: flex;
            justify-content: space-around;
            align-items: center;
            padding: 10px 0;
            border-top: 1px solid #ddd;
            background-color: #fff;
        }

        .bottom-nav a {
            color: #888;
            font-size: 1.4em;
            text-decoration: none;
            transition: color 0.2s ease-in-out;
        }

        .bottom-nav a.active,
        .bottom-nav a:hover {
            color: #007bff;
        }

        @media (max-width: 600px) {
            .card-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            🍽️ <?php echo htmlspecialchars($restaurantName); ?>님, 안녕하세요!
        </div>

        <div class="dashboard">
            <div class="card-grid">
            <div class="card">
                    <div class="card-title">오늘 매출</div>
                    <div class="card-value">₩<?php echo number_format($todaySales); ?></div>
                </div>
                <div class="card">
                    <div class="card-title">오늘 예약</div>
                    <div class="card-value"><?php echo $todayReservations; ?>건</div>
                </div>
                <div class="card">
                    <div class="card-title">신규 리뷰</div>
                    <div class="card-value"><?php echo $newReviews; ?>건</div>
                </div>
                
                <div class="card">
                    <div class="card-title">진행 중 주문</div>
                    <div class="card-value"><?php echo $orderdCount; ?>건</div>
                </div>
                <div class="card">
                    <div class="card-title">완료된 주문</div>
                    <div class="card-value"><?php echo $completedCount; ?>건</div>
                </div>
            </div>
        </div>

        <nav class="bottom-nav">
            <a href="main.php" class="active" title="홈"><i class="fa-solid fa-house"></i></a>
    
            <a href="../pages/order/orderlist.php" title="주문 목록"><i class="fa-solid fa-receipt"></i></a>
            <a href="mypage.php" title="마이페이지"><i class="fa-solid fa-user"></i></a>
        </nav>
    </div>
</body>
</html>
