<?php
session_start();
require_once('../../includes/db_connect.php');

// 로그인 확인
if (!isset($_SESSION['user_id'])) {
    die("로그인이 필요합니다.");
}

$adminId = $_SESSION['user_id'];

// 관리자 로그 가져오기
$sql = "SELECT action, description, ip_address, user_agent, created_at 
        FROM AdminActivityLog 
        WHERE admin_id = ? 
        ORDER BY created_at DESC";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $adminId);
$stmt->execute();
$result = $stmt->get_result();
$logs = $result->fetch_all(MYSQLI_ASSOC);
$stmt->close();
?>

<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <title>관리자 작업 로그</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <style>
        body, html {
            margin: 0;
            padding: 0;
            font-family: "Apple SD Gothic Neo", sans-serif;
            background-color: #f9f9f9;
            height: 100%;
        }

        .container {
            display: flex;
            flex-direction: column;
            height: 100vh;
            max-width: 400px;
            margin: 0 auto;
            background-color: #fff;
        }

        .header {
            background-color: #007bff;
            color: white;
            padding: 15px;
            font-size: 1em;
            font-weight: bold;
            text-align: center;
        }

        .log-list {
            flex: 1;
            overflow-y: auto;
            padding: 15px;
        }

        .log-item {
            background-color: #fff;
            border-radius: 10px;
            padding: 10px;
            margin-bottom: 10px;
            box-shadow: 0 2px 6px rgba(0,0,0,0.05);
        }

        .log-item .action {
            font-weight: bold;
            color: #007bff;
        }

        .log-item .description {
            margin: 5px 0;
            color: #555;
        }

        .log-item .meta {
            font-size: 0.8em;
            color: #888;
        }

        .bottom-nav {
            display: flex;
            justify-content: space-around;
            align-items: center;
            padding: 10px 0;
            border-top: 1px solid #ddd;
            background-color: #fff;
        }

        .bottom-nav a {
            color: #888;
            font-size: 1.4em;
            text-decoration: none;
        }

        .bottom-nav a.active,
        .bottom-nav a:hover {
            color: #007bff;
        }
    </style>
</head>
<body>
<div class="container">
    <div class="header">
         관리자 작업 로그
    </div>

    <div class="log-list">
        <?php if (empty($logs)): ?>
            <p>작업 로그가 없습니다.</p>
        <?php else: ?>
            <?php foreach ($logs as $log): ?>
                <div class="log-item">
                    <div class="action"><?= htmlspecialchars($log['action']) ?></div>
                    <div class="description"><?= nl2br(htmlspecialchars($log['description'])) ?></div>
                    <div class="meta">
                        <?= htmlspecialchars($log['created_at']) ?><br>
                        IP: <?= htmlspecialchars($log['ip_address']) ?><br>
                        UA: <?= htmlspecialchars($log['user_agent']) ?>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>

    <nav class="bottom-nav">
        <a href="../main.php"><i class="fa-solid fa-house"></i></a>
        <a href="../pages/order/orderlist.php"><i class="fa-solid fa-receipt"></i></a>
        <a href="../mypage.php"><i class="fa-solid fa-user"></i></a>
    </nav>
</div>
</body>
</html>
