<?php
session_start();
require_once('../../includes/db_connect.php');

// 로그인 확인
if (!isset($_SESSION['user_id'])) {
    die("로그인이 필요합니다.");
}

$admin_id = $_SESSION['user_id'];

// POST 요청 여부 확인
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    die("잘못된 접근입니다.");
}

// 필수 POST 데이터 확인
if (!isset($_POST['declaration_id'], $_POST['action'])) {
    die("필수 데이터가 없습니다.");
}

$declaration_id = (int)$_POST['declaration_id'];
$action = $_POST['action'];

// 허용된 작업 확인
if (!in_array($action, ['approve', 'reject'])) {
    die("잘못된 작업 요청입니다.");
}

// 신고 리뷰가 현재 관리자 소속 가게의 리뷰인지 확인 (권한 체크)
$sql = "
    SELECT r.restaurant_id, rest.user_id
    FROM Declarations d
    JOIN Reviews r ON d.review_id = r.review_id
    JOIN Restaurants rest ON r.restaurant_id = rest.restaurant_id
    WHERE d.declaration_id = ?
";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $declaration_id);
$stmt->execute();
$stmt->bind_result($restaurant_id, $restaurant_owner_id);
if (!$stmt->fetch()) {
    $stmt->close();
    die("해당 신고 내역이 존재하지 않습니다.");
}
$stmt->close();

if ($restaurant_owner_id !== $admin_id) {
    die("권한이 없습니다.");
}

// ENUM 값에 맞게 상태 지정
$new_status = $action === 'approve' ? 'action_taken' : 'dismissed';

// 상태 업데이트
$sql_update = "UPDATE Declarations SET status = ? WHERE declaration_id = ?";
$stmt = $conn->prepare($sql_update);
$stmt->bind_param("si", $new_status, $declaration_id);

if ($stmt->execute()) {
    $stmt->close();
    // 성공 시 목록 페이지로 이동
    header("Location: dec_manage.php");
    exit;
} else {
    $stmt->close();
    die("업데이트 중 오류가 발생했습니다.");
}
