<?php
session_start();
require_once('../../includes/db_connect.php');

// 로그인한 가게 관리자 정보
if (!isset($_SESSION['user_id'])) {
    die("로그인이 필요합니다.");
}
$admin_id = $_SESSION['user_id'];

// 해당 관리자가 운영하는 restaurant_id 가져오기
$sql = "SELECT restaurant_id FROM Restaurants WHERE user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $admin_id);
$stmt->execute();
$stmt->bind_result($restaurant_id);
if (!$stmt->fetch()) {
    die("등록된 식당이 없습니다.");
}
$stmt->close();

// 신고된 리뷰 목록 가져오기
$sql = "
    SELECT d.declaration_id, d.reason, d.status, d.created_at AS declaration_time,
           r.review_id, r.comment, r.rating, r.photo_url, r.created_at AS review_time,
           u.username AS reporter_name,
           ru.username AS reported_user_name
    FROM Declarations d
    JOIN Reviews r ON d.review_id = r.review_id
    JOIN Users u ON d.reporter_user_id = u.user_id
    JOIN Users ru ON d.reported_user_id = ru.user_id
    WHERE r.restaurant_id = ?
    ORDER BY d.created_at DESC
";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $restaurant_id);
$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="ko">
<head>
<meta charset="UTF-8" />
<title>신고된 리뷰 관리</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
<style>
  html, body {
    margin: 0;
    padding: 0;
    font-family: "Apple SD Gothic Neo", sans-serif;
    background-color: #f9f9f9;
    height: 100%;
  }

  /* 전체 컨테이너 */
  .container {
    max-width: 400px;
    margin: 0 auto;
    padding: 15px;
    background: #fff;
    min-height: 100vh;
    display: flex;
    flex-direction: column;
    justify-content: space-between;
    box-sizing: border-box;
  }

  h2 {
    text-align: center;
    margin-bottom: 20px;
  }

  /* 신고 내역 리스트 */
  .report-list {
    flex-grow: 1;
    overflow-y: auto;
    margin-bottom: 60px; /* 하단 네비바 공간 확보 */
  }

  /* 신고 박스 */
  .report-box {
    border: 1px solid #ccc;
    border-radius: 8px;
    padding: 12px;
    margin-bottom: 12px;
    background-color: #fafafa;
  }

  .report-box p {
    margin: 6px 0;
    word-break: break-word;
  }

  .buttons {
    margin-top: 10px;
  }

  .buttons button {
    margin-right: 10px;
    padding: 6px 12px;
    border: none;
    border-radius: 4px;
    cursor: pointer;
    font-weight: bold;
  }

  .approve {
    background-color: #4CAF50;
    color: white;
  }

  .reject {
    background-color: #f44336;
    color: white;
  }

  /* 하단 네비게이션 */
  .bottom-nav {
    position: fixed;
    bottom: 0;
    left: 50%;
    transform: translateX(-50%);
    max-width: 400px;
    width: 100%;
    display: flex;
    justify-content: space-around;
    align-items: center;
    background: #fff;
    border-top: 1px solid #ccc;
    padding: 10px 0;
    box-sizing: border-box;
    z-index: 100;
  }

  .bottom-nav a {
    color: #888;
    font-size: 1.4em;
    text-decoration: none;
    transition: color 0.2s ease-in-out;
  }

  .bottom-nav a.active,
  .bottom-nav a:hover {
    color: #007bff;
  }
</style>
</head>
<body>
  <div class="container">
    <h2>신고된 리뷰 관리</h2>

    <div class="report-list">
      <?php while ($row = $result->fetch_assoc()): ?>
      <div class="report-box">
        <p><strong>신고 사유:</strong> <?= htmlspecialchars($row['reason']) ?></p>
        <p><strong>리뷰 내용:</strong> <?= htmlspecialchars($row['comment']) ?></p>
        <p><strong>신고자:</strong> <?= htmlspecialchars($row['reporter_name']) ?> / <strong>신고일:</strong> <?= htmlspecialchars($row['declaration_time']) ?></p>
        <p><strong>상태:</strong> <?= htmlspecialchars($row['status']) ?></p>

        <?php if ($row['status'] === 'pending'): ?>
        <form action="handle_dec.php" method="post" class="buttons">
          <input type="hidden" name="declaration_id" value="<?= $row['declaration_id'] ?>">
          <button type="submit" name="action" value="approve" class="approve">승인</button>
          <button type="submit" name="action" value="reject" class="reject">기각</button>
        </form>
        <?php endif; ?>
      </div>
      <?php endwhile; ?>
    </div>

    <nav class="bottom-nav">
      <a href="../main.php" title="홈"><i class="fa-solid fa-house"></i></a>
      <a href="../../pages/order/orderlist.php" title="주문 목록"><i class="fa-solid fa-receipt"></i></a>
      <a href="../mypage.php" title="마이페이지"><i class="fa-solid fa-user"></i></a>
    </nav>
  </div>
</body>
</html>
