<?php
require_once('../../includes/db_connect.php');
require_once('../../includes/islogin.php');

$success_message = '';
$error_message = '';
$generated_coupon_code = '';

// 폼이 제출되었는지 확인 (등록 버튼 클릭 시)
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['register_coupon'])) {

    $discount_input = trim($_POST['discount'] ?? '');
    $valid_until_input = trim($_POST['date'] ?? '');
    $min_order_amount_input = trim($_POST['minprice'] ?? '');

    $discount_percent = null;
    if (preg_match('/^(\d+(\.\d+)?)\s*%?$/', $discount_input, $matches_discount)) {
        $discount_percent = (float)$matches_discount[1];
        if ($discount_percent <= 0) {
            $error_message = "쿠폰 할인율은 0보다 커야 합니다.";
            $discount_percent = null;
        }
    } else if (!empty($discount_input)) {
        $error_message = "쿠폰 할인율 형식이 올바르지 않습니다. (예: 10 또는 10%)";
    }

    $valid_until = null;
    if (empty($error_message) && preg_match('/^(\d{4})[\/\-](\d{2})[\/\-](\d{2})$/', $valid_until_input, $matches_date)) {
        if (checkdate((int)$matches_date[2], (int)$matches_date[3], (int)$matches_date[1])) {
            $valid_until = sprintf("%04d-%02d-%02d", $matches_date[1], $matches_date[2], $matches_date[3]);
            // 오늘 날짜보다 이전인지 확인
            if (strtotime($valid_until) < strtotime(date('Y-m-d'))) {
                 $error_message = "쿠폰 기간은 오늘 또는 오늘 이후 날짜여야 합니다.";
                 $valid_until = null;
            }
        } else {
            $error_message = "쿠폰 기간 날짜가 유효하지 않습니다.";
        }
    } else if (empty($error_message) && !empty($valid_until_input)) {
        $error_message = "쿠폰 기간 형식이 올바르지 않습니다. (예: YYYY/MM/DD 또는 YYYY-MM-DD)";
    }

    $min_order_amount = null;
    if (empty($error_message) && preg_match('/^([\d,]+)\s*(?:원)?$/', $min_order_amount_input, $matches_price)) {
        $min_order_amount_val = (int)str_replace(',', '', $matches_price[1]);
        if ($min_order_amount_val >= 0) {
            $min_order_amount = $min_order_amount_val;
        } else {
            $error_message = "최소 주문 금액은 0 이상이어야 합니다.";
        }
    } else if (empty($error_message) && !empty($min_order_amount_input)) {
        $error_message = "최소 주문 금액 형식이 올바르지 않습니다. (예: 10000 또는 10,000원)";
    }

    if (empty($discount_input) || empty($valid_until_input) || empty($min_order_amount_input)) {
        $error_message = "모든 필수 필드(쿠폰 할인율, 쿠폰 기간, 최소 주문 금액)를 입력해주세요.";
    }

    if (empty($error_message) && $discount_percent !== null && $valid_until !== null && $min_order_amount !== null) {
        // 1. 쿠폰 코드 생성 (예: 8자리 영문 대문자 + 숫자 조합)
        do {
            $generated_coupon_code = strtoupper(substr(str_shuffle(str_repeat('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ', 8)), 0, 8));
            $is_code_unique = true;
        } while (!$is_code_unique);


        // 2. 데이터베이스에 저장 (실제 DB 연동 부분)
        if (isset($conn) && $conn instanceof mysqli && !$conn->connect_error) {
        try {
            $stmt = $conn->prepare("INSERT INTO Coupons (code, discount_percent, valid_until, min_order_amount) VALUES (?, ?, ?, ?)");
            $stmt->bind_param("sdsi", $generated_coupon_code, $discount_percent, $valid_until, $min_order_amount);

            if ($stmt->execute()) {
                $success_message = "쿠폰이 성공적으로 등록되었습니다. 생성된 쿠폰 코드: <strong>" . htmlspecialchars($generated_coupon_code) . "</strong>";
                $_POST = array();
            } else {
                if ($conn->errno == 1062) {
                    $error_message = "쿠폰 코드 생성 중 중복이 발생했습니다. 다시 시도해주세요.";
                } else {
                    $error_message = "쿠폰 등록에 실패했습니다. 데이터베이스 오류: " . htmlspecialchars($stmt->error);
                }
            }
            $stmt->close();
        } catch (Exception $e) {
            $error_message = "데이터베이스 작업 중 예외 발생: " . htmlspecialchars($e->getMessage());
        }
    } else {
        $error_message = "데이터베이스 연결을 사용할 수 없습니다. db_connect.php 설정을 확인해주세요.";
        if (isset($conn) && $conn->connect_error) {
             $error_message .= " 오류: " . $conn->connect_error;
        }
    }
  }
}
?>
<!DOCTYPE html>
<html lang="ko">

<head>
  <meta charset="UTF-8">
  <title>쿠폰 등록 관리</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
  <style>
    * {
      box-sizing: border-box;
    }
    body {
      font-family: 'Arial', sans-serif;
      background-color: #f9f9f9;
      margin: 0;
      padding: 0;
      display: flex;
      justify-content: center;
      align-items: center;
      min-height: 100vh;
    }
    .form-container {
      background-color: #fff;
      border: 1px solid #ddd;
      width: 100%;
      max-width: 350px;
      margin: 20px;
      display: flex;
      flex-direction: column;
      padding: 20px;
      border-radius: 8px;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    }

    .page-header {
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding-bottom: 10px;
        border-bottom: 1px solid #eee;
        margin-bottom: 15px;
    }
    .page-header .back-link {
        text-decoration: none;
        color: #333;
        font-size: 1.2em;
        padding: 5px;
    }
    .page-header h2 {
        margin: 0;
        font-size: 1.25em;
        text-align: center;
        flex-grow: 1;
    }
    .page-header .placeholder {
        width: 24px;
        padding: 5px;
        visibility: hidden;
    }

    form {
      display: flex;
      flex-direction: column;
      flex-grow: 1;
    }
    .form-fields {
      flex-grow: 1;
    }
    .form-group {
      margin-bottom: 18px;
    }
    label {
      display: block;
      font-weight: bold;
      margin-bottom: 8px;
      font-size: 0.95em;
    }
    input[type="text"] {
      width: 100%;
      padding: 12px;
      background-color: #f3f3f3;
      border: 1px solid #ddd;
      border-radius: 4px;
      font-size: 1em;
    }
    .form-buttons {
      display: flex;
      flex-direction: column;
      gap: 10px;
      margin-top: auto;
    }
    .btn {
      width: 100%;
      background-color: #007bff;
      color: white;
      padding: 12px;
      border: none;
      border-radius: 5px;
      font-weight: bold;
      cursor: pointer;
      font-size: 1em;
      transition: background-color 0.2s ease;
    }
    .btn-delete {
        background-color: #dc3545;
    }
    .btn:hover {
      opacity: 0.85;
    }
    .btn-delete:hover {
        background-color: #c82333;
    }
    .message { padding: 10px; margin-bottom: 15px; border-radius: 4px; font-size: 0.9em; text-align:center; }
    .success { background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
    .error { background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
  </style>
</head>

<body>
  <div class="form-container">
    <div class="page-header">
      <a href="../../auth/redirect-mypage.php" title="뒤로가기" class="back-link">
        <i class="fas fa-arrow-left"></i>
      </a>
      <h2>쿠폰 등록 관리</h2>
      <span class="placeholder"></span> </div>

    <?php if (!empty($success_message)): ?>
    <div class="message success"><?php echo $success_message; ?></div>
    <?php endif; ?>
    <?php if (!empty($error_message)): ?>
    <div class="message error"><?php echo $error_message; ?></div>
    <?php endif; ?>

    <form method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>">
      <div class="form-fields">
        <div class="form-group">
          <label for="discount">쿠폰 할인율 <span style="color:red;">*</span></label>
          <input type="text" id="discount" name="discount" placeholder="예: 10 또는 10%"
            value="<?php echo isset($_POST['discount']) ? htmlspecialchars($_POST['discount']) : ''; ?>" required>
        </div>

        <div class="form-group">
          <label for="date">쿠폰 유효기간 <span style="color:red;">*</span></label>
          <input type="text" id="date" name="date" placeholder="예: 2025/12/31 또는 2025-12-31"
            value="<?php echo isset($_POST['date']) ? htmlspecialchars($_POST['date']) : ''; ?>" required>
        </div>

        <div class="form-group">
          <label for="minprice">최소 주문 금액 <span style="color:red;">*</span></label>
          <input type="text" id="minprice" name="minprice" placeholder="예: 10000 또는 10,000원"
            value="<?php echo isset($_POST['minprice']) ? htmlspecialchars($_POST['minprice']) : ''; ?>" required>
        </div>
      </div>

      <div class="form-buttons">
        <button type="submit" name="register_coupon" class="btn">등록</button>
        <button type="button" class="btn btn-delete"
          onclick="alert('삭제 기능은 현재 구현되지 않았습니다.');">삭제</button>
      </div>
    </form>
  </div>
</body>
</html>